package net.limosoft

import com.fasterxml.jackson.core.type.TypeReference
import com.fasterxml.jackson.databind.ObjectMapper
import org.codehaus.groovy.grails.commons.ConfigurationHolder
import org.codehaus.groovy.grails.commons.GrailsApplication
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware

import java.lang.annotation.Annotation
import java.lang.reflect.Type
import javax.ws.rs.Consumes
import javax.ws.rs.WebApplicationException
import javax.ws.rs.core.MediaType
import javax.ws.rs.core.MultivaluedMap
import javax.ws.rs.ext.MessageBodyReader
import javax.ws.rs.ext.Provider

import static org.grails.jaxrs.support.ConverterUtils.*
import static org.grails.jaxrs.support.ProviderUtils.isJsonType
import static org.grails.jaxrs.support.ProviderUtils.isXmlType

/**
 * @Author: Dale "Ducky" Lotts  - dale@dalelotts.com
 * @Since: 2012/08/13
 */

@Provider
@Consumes(['text/xml', 'application/xml', 'text/x-json', 'application/json'])

class DomainObjectReader  implements MessageBodyReader<Object>, GrailsApplicationAware {

    private static final TypeReference<HashMap<String, Object>> typeRef  = new TypeReference<HashMap<String,Object>>() {};

    GrailsApplication grailsApplication

       /**
        * Returns <code>true</code> if <code>type</code> is a Grails domain class
        * and the request content type is one of <code>text/xml</code>,
        * <code>application/xml</code>, <code>text/x-json</code> or
        * <code>application/json</code>. If <code>isEnabled()</code> returns
        * <code>false</code> this method will always return <code>false</code>.
        */
       boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
           return isEnabled() && grailsApplication.isDomainClass(type) && (isXmlType(mediaType) || isJsonType(mediaType))
       }

       /**
        * Creates a Grails domain object from an XML or JSON request entity
        * stream.
        */
       Object readFrom(Class type, Type genericType,
               Annotation[] annotations, MediaType mediaType,
               MultivaluedMap httpHeaders, InputStream entityStream)
           throws IOException, WebApplicationException {

           if (isXmlType(mediaType)) {
               return readFromXml(type, entityStream, getDefaultXMLEncoding(grailsApplication))
           } else { // JSON
               return readFromJson(type, entityStream, getDefaultJSONEncoding(grailsApplication))
           }

       }

       /**
        * If <code>false</code> this reader will be skipped. Returns
        * <code>true</code> by default.
        */
       protected boolean isEnabled() {
           !ConfigurationHolder.config.net.limosoft.DomainObjectReader.disable
       }

       /**
        * Construct domain object from xml map obtained from entity stream.
        */
       protected Object readFromXml(Class type, InputStream entityStream, String charset) {
           def map = xmlToMap(entityStream, charset)
           def result = type.metaClass.invokeConstructor(map)

           // Workaround for http://jira.codehaus.org/browse/GRAILS-1984
           if (!result.id) {
               result.id = idFromMap(map)
           }
           result
       }

       /**
        * Construct domain object from json map obtained from entity stream.
        */
       protected Object readFromJson(Class type, InputStream entityStream, String charset) {

           def mapper = new ObjectMapper();
           def parsedJSON = mapper.readValue(entityStream, typeRef);

           Map<String, Object> map = new HashMap<>();

           parsedJSON.entrySet().each {Map.Entry<String, Object> entry ->
               if (List.isAssignableFrom(entry.getValue().getClass())) {

                   List values = (List) entry.getValue();
                   int limit = values.size()
                   for (int i = 0; i <  limit; i++) {
                       final theValue = values.get(i)
                       map.put(entry.key + '[' + i + ']', theValue)

                       appendMapValues(map, theValue, entry.key + '[' + i + ']' )

                   }
               } else {
                   map.put(entry.key, entry.value);
               }
           }

           def result = type.metaClass.invokeConstructor(map)


           // Workaround for http://jira.codehaus.org/browse/GRAILS-1984
           if (!result.id) {
               result.id = idFromMap(map)
           }
           result
       }

    private void appendMapValues(Map<String, Object> theMap, Object theValue, String prefix) {
        if (Map.isAssignableFrom(theValue.getClass())) {

            Map<String, Object> valueMap = (Map<String, Object>) theValue;

            for (Map.Entry<String, Object> valueEntry : valueMap.entrySet()) {
                theMap.put(prefix + '.' + valueEntry.key, valueEntry.value)
                appendMapValues(theMap, valueEntry.value, prefix + '.' + valueEntry.key)
            }
        }
    }
}
